/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : generates the hash password for the users 
 *                 on the /etc/smb_passwd file.
 *--------------------------------------------------------------------
 * MODULE        :
 * DEPENDENCIES  :
 ********************************************************************/

#pragma pack(1)
static char rcsid[] = "@(#) __FILE__: $Header: /windriver/nq_010207/nqpwd/des.c 2     7/02/01 7:48p Mutazag $";

/*
 ***** Include files *************************************************
 */

/*
#include "nqsystem.h"

#include "session.h"
#include "desalgo.h"
#include "verror.h"
*/

typedef unsigned char UCHAR;


static UCHAR perm1[56] = { 57, 49, 41, 33, 25, 17, 9,
                            1, 58, 50, 42, 34, 26, 18,
                           10,  2, 59, 51, 43, 35, 27,
                           19, 11,  3, 60, 52, 44, 36,
                           63, 55, 47, 39, 31, 23, 15,
                            7, 62, 54, 46, 38, 30, 22,
                           14,  6, 61, 53, 45, 37, 29,
                           21, 13,  5, 28, 20, 12,  4 };

static UCHAR perm2[48] = { 14, 17, 11, 24,  1,  5,
                            3, 28, 15,  6, 21, 10,
                           23, 19, 12,  4, 26,  8,
                           16,  7, 27, 20, 13,  2,
                           41, 52, 31, 37, 47, 55,
                           30, 40, 51, 45, 33, 48,
                           44, 49, 39, 56, 34, 53,
                           46, 42, 50, 36, 29, 32 };

static UCHAR perm3[64] = { 58, 50, 42, 34, 26, 18, 10,  2,
                           60, 52, 44, 36, 28, 20, 12,  4,
                           62, 54, 46, 38, 30, 22, 14,  6,
                           64, 56, 48, 40, 32, 24, 16,  8,
                           57, 49, 41, 33, 25, 17,  9,  1,
                           59, 51, 43, 35, 27, 19, 11,  3,
                           61, 53, 45, 37, 29, 21, 13,  5,
                           63, 55, 47, 39, 31, 23, 15,  7 } ;

static UCHAR perm4[48] = { 32,  1,  2,  3,  4, 5,
                            4,  5,  6,  7,  8,  9,
                            8,  9, 10, 11, 12, 13,
                           12, 13, 14, 15, 16, 17,
                           16, 17, 18, 19, 20, 21,
                           20, 21, 22, 23, 24, 25,
                           24, 25, 26, 27, 28, 29,
                           28, 29, 30, 31, 32,  1 };

static UCHAR perm5[32] = { 16,  7, 20, 21,
                           29, 12, 28, 17,
                            1, 15, 23, 26,
                            5, 18, 31, 10,
                            2,  8, 24, 14,
                           32, 27,  3,  9,
                           19, 13, 30,  6,
                           22, 11,  4, 25 };

static UCHAR perm6[64] ={ 40,  8, 48, 16, 56, 24, 64, 32,
                          39,  7, 47, 15, 55, 23, 63, 31,
                          38,  6, 46, 14, 54, 22, 62, 30,
                          37,  5, 45, 13, 53, 21, 61, 29,
                          36,  4, 44, 12, 52, 20, 60, 28,
                          35,  3, 43, 11, 51, 19, 59, 27,
                          34,  2, 42, 10, 50, 18, 58, 26,
                          33,  1, 41,  9, 49, 17, 57, 25 };

static UCHAR sc[16] ={1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};

static UCHAR sbox[8][4][16] = {
   {{14,  4, 13, 1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9, 0,  7},
    { 0, 15,  7, 4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5, 3,  8},
    { 4,  1, 14, 8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10, 5,  0},
    {15, 12,  8, 2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0, 6, 13}},

    {{15,  1,  8, 14,  6, 11,  3,  4,  9, 7,  2, 13, 12, 0,  5, 10},
     { 3, 13,  4,  7, 15,  2,  8, 14, 12, 0,  1, 10,  6, 9, 11,  5},
     { 0, 14,  7, 11, 10,  4, 13,  1,  5, 8, 12,  6,  9, 3,  2, 15},
     {13,  8, 10,  1,  3, 15,  4,  2, 11, 6,  7, 12,  0, 5, 14,  9}},

    {{10,  0,  9, 14, 6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8},
     {13,  7,  0,  9, 3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1},
     {13,  6,  4,  9, 8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7},
     { 1, 10, 13,  0, 6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12}},

    {{ 7, 13, 14, 3,  0,  6,  9, 10,  1, 2, 8,  5, 11, 12,  4, 15},
     {13,  8, 11, 5,  6, 15,  0,  3,  4, 7, 2, 12,  1, 10, 14,  9},
     {10,  6,  9, 0, 12, 11,  7, 13, 15, 1, 3, 14,  5,  2,  8,  4},
     { 3, 15,  0, 6, 10,  1, 13,  8,  9, 4, 5, 11, 12,  7,  2, 14}},

    {{ 2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13, 0, 14,  9},
     {14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3, 9,  8,  6},
     { 4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6, 3,  0, 14},
     {11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10, 4,  5,  3}},

    {{12,  1, 10, 15, 9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11},
     {10, 15,  4,  2, 7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8},
     { 9, 14, 15,  5, 2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6},
     { 4,  3,  2, 12, 9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13}},

    {{ 4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1},
     {13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6},
     { 1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2},
     { 6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12}},

    {{13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7},
     { 1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2},
     { 7, 11,  4,  1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8},
     { 2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11}}};


static void permute(UCHAR *out, UCHAR *in, UCHAR *p, int n);
static void lshift( UCHAR *d, int count, int num);
static void concat(UCHAR *out, UCHAR *in1, UCHAR *in2, int l1, int l2);
static void xor(UCHAR *out, UCHAR *in1, UCHAR *in2, int num);



/*
 *************************** Global variables ************************
 */

#define    PC1_TBL    56
#define    RILI_FINAL 64
#define    FIRST_PER  28
#define    PERMU_IP   32
#define    PC2_1      16
#define    PC2_2      48
#define    B_ARR_1    8
#define    B_ARR_2    6

/*
 *====================================================================
 * FUNCTION : smbDESalgo()
 *--------------------------------------------------------------------
 * PURPOSE  : performs the DES algorithm on the input and key arrays.
 *--------------------------------------------------------------------
 * PARAMS   : UCHAR    *smbucResult64  OUT
 *            UCHAR    *smbucaIn64     IN
 *            UCHAR    *smbucaKey64    IN
 *
 * RETURNS  : void
 *--------------------------------------------------------------------
 * GLOBALS  : <Optional>
 *--------------------------------------------------------------------
 * COMMENTS : <Optional>
 *====================================================================
 */

void smbDESalgo( 
        UCHAR    *smbucResult64,
        UCHAR    *smbucaIn64,
        UCHAR    *smbucaKey64
     )
{
    int      i;                        /* working counter           */
    int      j;                        /* working counter           */
    int      k;                        /* working counter           */
    UCHAR    smbPermutePC1[ PC1_TBL ]; /* holds 1st permutation     */
    UCHAR    smbucaRiLi[ RILI_FINAL ]; /* final concate result      */
    UCHAR    smbucConcaCD[ PC1_TBL ];  /* concatenated arrays       */
    UCHAR    smbPerPC2[ PC2_1 ][ PC2_2 ];/* 2nd permutation result  */
    UCHAR    smbucC[ FIRST_PER ];      /* holds the 1st 28-bits of  */
                                       /* a 56-bits permuted array  */
    UCHAR    smbucD[ FIRST_PER ];      /* holds the 2nd 28-bits of  */
                                       /* a 56-bits permuted array  */
    UCHAR    smbucaIP[ RILI_FINAL ];   /* the initial permutation   */
                                       /* IP of a 64-bit input data */
    UCHAR    smbucaIP_L[ PERMU_IP ];   /* holds the first half of   */
                                       /* the permuted block IP     */
    UCHAR    smbucaIP_R[ PERMU_IP ];   /* holds the second half of  */
                                       /* the permuted block IP     */
/*
 * BEGINNING OF smbDESalgo FUNCTION
 */

    /* performs the first permutation */

    permute( smbPermutePC1, smbucaKey64, perm1, 56 ) ;

    /* split the key into left and right halves, each of 28-bits */

    for ( i = 0 ; i < 28 ; i++ )
    {
        smbucC[ i ] = smbPermutePC1[ i ];        
    }

    for ( i = 0 ; i < 28 ; i++ )
    {
        smbucD[ i ] = smbPermutePC1[ i + 28 ];
    }

    /* create 16 blocks, by left shifting smbucC, and smbucD */

    for ( i = 0 ; i < 16 ; i++ ) 
    {
        lshift( smbucC, sc[ i ], 28 );
        lshift( smbucD, sc[ i ], 28 );

        /* concatenate smbucC, & smbucD to form smbucConcaCD*/

        concat( smbucConcaCD, smbucC, smbucD, 28, 28 ); 

        /* apply the permutation table PC-2 to each of the */
        /* concatenated pairs*/ 

        permute( smbPerPC2[ i ], smbucConcaCD, perm2, 48 );
    }                              

    /* initial permutation IP of the 64-bit input data    */

    permute( smbucaIP, smbucaIn64, perm3, 64 );

    /* divide the permuted block IP into 2 half, each of 32-bits */

    for ( j = 0 ; j < 32 ; j++)
    {
        smbucaIP_L[ j ] = smbucaIP[ j ];        
        smbucaIP_R[ j ] = smbucaIP[ j + 32 ];
    }

    /*
     * preceed through 16 iterations
     */

    for ( i = 0 ; i < 16 ; i++ ) 
    {
        UCHAR smbucaER_E_Bit[ PC2_2 ];
        UCHAR smbucaER_xor_K[ PC2_2 ];
        UCHAR smbucaB[ B_ARR_1 ][ B_ARR_2 ];
        UCHAR smbucaSiBi[ PERMU_IP ];
        UCHAR smbucaPSiBi[ PERMU_IP ];
        UCHAR smbucaRi[ PERMU_IP ];    

        /* expand each 32-bits to 48-bits, using the */
        /* (E Bit-Selection Table ) */

        permute( smbucaER_E_Bit, smbucaIP_R, perm4, 48 );

        /* perform XOR on smbucaER_E_Bit */

        xor( smbucaER_xor_K, smbucaER_E_Bit, smbPerPC2[ i ], 48 );

        /* arrange the B array of eight groups of six bits */

        for ( j = 0 ; j < 8 ; j++ )
        {            
            for ( k = 0 ; k < 6 ; k++ )
            {
                smbucaB[ j ][ k ] = smbucaER_xor_K[ j*6 + k];    
            }
        }

        /* get the address of the S- boxes */

        for ( j = 0 ; j < 8 ; j++ )
        {    
            int    smbaRow;
            int    smbaColumn;

            smbaRow = ( smbucaB[ j ][ 0 ] << 1 ) | smbucaB[ j ][ 5 ];

            smbaColumn = ( smbucaB[ j ][ 1 ] << 3 ) 
                         | ( smbucaB[ j ][ 2 ] << 2 )
                         | ( smbucaB[ j ][ 3 ] << 1 )
                         | smbucaB[ j ][ 4 ] ; 

            for ( k = 0 ; k < 4 ; k++ ) 
            {
                smbucaB[ j ][ k ] =  
                        ( sbox[j][smbaRow][smbaColumn] &
                        ( 1 << ( 3 - k ) ) ) ? 1 : 0;
            }
        }

        /* the output of the S-boxes */

        for ( j = 0 ; j < 8 ; j++ )
        {            
            for ( k = 0 ; k < 4 ; k++ )
            {
                smbucaSiBi[ j * 4 + k ] = smbucaB[ j ][ k ];
            }    
        }

        /* the permutation of the S-box output    */

        permute( smbucaPSiBi, smbucaSiBi, perm5, 32 );

        /* find the XOR of smbucaIP_L and smbucaPSiBi */

        xor( smbucaRi, smbucaIP_L, smbucaPSiBi, 32 );

        for ( j = 0 ; j < 32 ; j++ )
        {
            smbucaIP_L[ j ] = smbucaIP_R[ j ];
        }

        for ( j = 0 ; j < 32 ; j++ )
        {
            smbucaIP_R[ j ] = smbucaRi[ j ];    
        }
    }

    /* apply the final permutation    */

    concat( smbucaRiLi, smbucaIP_R, smbucaIP_L, 32, 32 );
    permute( smbucResult64, smbucaRiLi, perm6, 64 );

} /* end of smbDESalgo Function */

/*
 *====================================================================
 * FUNCTION : permute()
 *--------------------------------------------------------------------
 * PURPOSE  : permutation function.
 *--------------------------------------------------------------------
 * PARAMS   : UCHAR  *out, 
 *            UCHAR  *in, 
 *            UCHAR  *p, 
 *            int    n
 *
 * RETURNS  : void
 *--------------------------------------------------------------------
 * GLOBALS  : <Optional>
 *--------------------------------------------------------------------
 * COMMENTS : <Optional>
 *====================================================================
 */

void permute(UCHAR *out, UCHAR *in, UCHAR *p, int n)
{
    int i;                                       /* working counter */

    for ( i = 0 ; i < n ; i++ )
    {
        out[ i ] = in[ p[ i ] - 1 ];    
    }
}

/*
 *====================================================================
 * FUNCTION : lshift()
 *--------------------------------------------------------------------
 * PURPOSE  : shift function.
 *--------------------------------------------------------------------
 * PARAMS   : UCHAR  *d, 
 *            int    count, 
 *            int    num 
 *
 * RETURNS  : void
 *--------------------------------------------------------------------
 * GLOBALS  : <Optional>
 *--------------------------------------------------------------------
 * COMMENTS : <Optional>
 *====================================================================
 */

void lshift( UCHAR *d, int count, int num)
{    
    int i;                             /* working counter           */
    UCHAR out[ 64 ];                   /* temp holder of the output */

    for ( i = 0 ; i < num ; i++ )
    {
        out[ i ] = d[ ( i + count ) % num ];    
    }

    for ( i = 0 ; i < num ; i++ )
    {
        d[ i ] = out[ i ];    
    }
}

/*
 *====================================================================
 * FUNCTION : concat()
 *--------------------------------------------------------------------
 * PURPOSE  : Concatenate function.
 *--------------------------------------------------------------------
 * PARAMS   : UCHAR  *out, 
 *            UCHAR  *in1, 
 *            UCHAR  *in2,
 *            int    l1,
 *            int    l2
 *
 * RETURNS  : void
 *--------------------------------------------------------------------
 * GLOBALS  : <Optional>
 *--------------------------------------------------------------------
 * COMMENTS : <Optional>
 *====================================================================
 */

void concat(UCHAR *out, UCHAR *in1, UCHAR *in2, int l1, int l2)
{    
    while ( l1-- )
    {
        *out++ = *in1++;    
    }

    while ( l2-- )
    {
        *out++ = *in2++;    
    }
}

/*
 *====================================================================
 * FUNCTION : xor()
 *--------------------------------------------------------------------
 * PURPOSE  : XOR function .
 *--------------------------------------------------------------------
 * PARAMS   : UCHAR  *out, 
 *            UCHAR  *in1, 
 *            UCHAR  *in2,
 *            int    num
 *
 * RETURNS  : void
 *--------------------------------------------------------------------
 * GLOBALS  : <Optional>
 *--------------------------------------------------------------------
 * COMMENTS : <Optional>
 *====================================================================
 */

void xor(UCHAR *out, UCHAR *in1, UCHAR *in2, int num)
{
    int i;                                       /* working counter */

    for ( i = 0 ; i < num ; i++ )
    {
        out[i] = in1[ i ] ^ in2[ i ];
    }
}
